# -*- coding: utf-8 -*- 
# http://scipy-lectures.github.com


#---------------------------------------------------
#Import důležitých součástí
#---------------------------------------------------
import numpy as np
import scipy as sp
import pylab as plt
from scipy import signal
from scipy import io as soubory
from glob import glob
import matplotlib as mat

import SumNaPozadi_functions as SnP
import Bunka_functions as Bunka
import Hmotnost_functions as Hmot
import BodBezSumu_fce as BbS


#---------------------------------------------------------------------------
# Potlačení šumu
#---------------------------------------------------------------------------
SirkaPole = 342
VyskaPole = 258
PocetCyklu = 400


#---------------------------------------------------------------------------
# Setřídění souborů
#---------------------------------------------------------------------------
Soubory = glob('mats/*.mat')
RoztrideneSoubory = sorted(Soubory)     # nahrání názvů souborů do seznamu
VyberSouboru = RoztrideneSoubory[::3]  # vybere každý n-tý (např 10.) soubor


#---------------------------------------------------------------------------
# Nahrání dat o buňkách a maskách ze souborů do mezipaměti
#---------------------------------------------------------------------------

# Už při tvorbě prázdného pole počítáme s 2 místy navíc - pro první a poslední matice - zprůměrovaný šum
VsechnyBunky = np.zeros((VyskaPole,SirkaPole,PocetCyklu+2))  
VsechnyMasky = np.zeros((VyskaPole,SirkaPole,PocetCyklu+2))
for i in range(1, PocetCyklu+1, 1):
    cesta = VyberSouboru[i]
    DataBunky = soubory.loadmat(cesta)
    CelaBunka = DataBunky['faze']
    VsechnyBunky[:,:,i] = CelaBunka
    CelaMaska = -DataBunky['maska']
    VsechnyMasky[:,:,i] = CelaMaska

#---------------------------------------------------------------------------
# Výpočet průměrných hodnot šumu v bodech
#---------------------------------------------------------------------------
PrumerneSumyVBodech = np.zeros((VyskaPole,SirkaPole))
for i in range(0, VyskaPole, 1):
    for j in range(0, SirkaPole, 1):
        #hmotnost všeho - hmotnost bunky
        CelkovaHodnotaSumu = np.sum(VsechnyBunky[i,j,:]) - np.sum(VsechnyBunky[i,j,:]*VsechnyMasky[i,j,:])
        PocetBoduSumu = PocetCyklu - np.sum(VsechnyMasky[i,j,:])
        if PocetBoduSumu == 0:
            PrumernaHodnotaSumu = 0
        else:
            PrumernaHodnotaSumu = CelkovaHodnotaSumu/float(PocetBoduSumu)
        PrumerneSumyVBodech[i,j] = PrumernaHodnotaSumu

#---------------------------------------------------------------------------
# Rozšíření množiny polí buněk a polí jejich masek
#---------------------------------------------------------------------------  
VsechnyBunky[:,:,0] = VsechnyBunky[:,:,(PocetCyklu+1)] = PrumerneSumyVBodech
VsechnyMasky[:,:,0] = VsechnyMasky[:,:,(PocetCyklu+1)] = np.zeros((VyskaPole,SirkaPole))


#---------------------------------------------------------------------------
# Výpočet polí šumu - s lineární interpolací neznámých okamžiků
#---------------------------------------------------------------------------
OpraveneBunky = np.zeros((VyskaPole,SirkaPole,PocetCyklu+2))
CasPrekryvu = 0
Predchozi = 0
for CisloRadku in range(0, VyskaPole, 1):
    for CisloSloupcu in range(0, SirkaPole, 1):
        # Volání funkce pro korekci šumu v bodě
        BodBezSumu = BbS.KorekceSumuVBode(VsechnyMasky[CisloRadku,CisloSloupcu,:], VsechnyBunky[CisloRadku,CisloSloupcu,:], PocetCyklu)  
        OpraveneBunky[CisloRadku,CisloSloupcu,:] = BodBezSumu # nahrání opraveného bodu do nové matice

# Nyní jsme vytvořili soubor matic, které symbolizují bunku bez šumu
#Pozor nultý a poslední prvek souboru je tu navíc - z výpočetních důvodů
#---------------------------------------------------------------------------


#---------------------------------------------------------------------------
# Uložení opravených buněk (při 120 bunkách 5:12)
#---------------------------------------------------------------------------
HmotnostiBunkyVCase = np.zeros(PocetCyklu)
for i in range(1, PocetCyklu+1, 1):         # Nebudeme tedy pracovat s prvním a posledním - uměle vytvořeným - polem
    fig = plt.figure(1)                     # Vytváření figure
    fig.clear()                             # Uvolnění paměti - ochrana proti jejímu přeplnění                  
    pl = fig.add_subplot(111)               # Vytváření subplotů
    OpravenaBunka = OpraveneBunky[:,:,i]    # Bereme jednotlivé opravené bunky
    Hmotnost2 = Hmot.HmotnostBunky(OpravenaBunka,VsechnyMasky[:,:,i])     # Výpočet hmotnosti bunky
    HmotnostiBunkyVCase[i-1] = Hmotnost2   
    print Hmotnost2                         # výpis spočítané hmotnosti zašuměné bunky
    img = pl.imshow(OpravenaBunka, cmap=mat.cm.gray, origin='lower', vmin=0, vmax=1.8)      # Tvorba obrázku
    fig.colorbar(img)                                                                       # Vykreslení colorbaru
    fig.savefig("OpravenaBunkaReal/obr_%03d.png" % (i-1))                                   # Ukládání obrázků    

print HmotnostiBunkyVCase

fig.clear()
plt.plot(VyberHmotnosti,'o', color="g")
plt.plot(VyberHmotnosti, alpha=0.2, color="g")
plt.xlabel('t [3s]')
plt.ylabel('m [pg]')
plt.show()    
